<?php

/**
 * Plugin Name: <code>has_blocks()</code> Fatal Error
 * Description: Testing whether a Fatal Error occurs in <code>has_blocks()</code> for <a href='https://core.trac.wordpress.org/ticket/55705' target='_blank'>#55705</a>.
 * Author:      WordPress Core Contributors
 * Author URI:  https://make.wordpress.org/core
 * License:     GPLv2 or later
 * Version:     1.0.0
 * Requires PHP: 7.0
 */

add_action(
	'admin_init',
	function() {
		$level = $message = '';

		try {
			$a_post = (object) array( 'ID' => 13585, 'filter' => 'display' );
			has_blocks( $a_post );
		} catch ( Error $e ) {
			$level   = 'error';
			$message = 'A Fatal Error occurred: ' . $e->getMessage();
		}

		if ( ! $message ) {
			$level   = 'success';
			$message = 'A Fatal Error did not occur';
		}

		add_action(
			'admin_notices',
			function() use ( $level, $message ) {
				echo '<div class="notice notice-' . $level . '"><p>' . $message . '.</p></div>';
			}
		);
	}
);
