<?php
/*
Plugin Name: Site/Homeurl inline validation 
Plugin URI: http://dd32.id.au/?test-plugin
Description: Site/Homeurl inline validation 
Version: 1.0
Author: DD32
Author URI: http://dd32.id.au/
*/

add_action('admin_head-options-general.php', '_siteurl_js');
function _siteurl_js() {
?>
<script type="text/javascript">
//<![CDATA[
	jQuery(document).ready(function($){
		$('#siteurl, #home').blur( function() {
			var oldurl = new Array();
			oldurl['siteurl'] = '<?php echo js_escape(get_option('siteurl')); ?>';
			oldurl['home'] = '<?php echo js_escape(get_option('home')); ?>';
			var spinnerurl = '<?php echo js_escape(admin_url('images/wpspin_light.gif')); ?>';
			var okurl = '<?php echo js_escape(admin_url('images/yes.png')); ?>';
			var errorurl = '<?php echo js_escape(admin_url('images/no.png')); ?>';

			var url = $(this).val();
			var id = $(this).attr('id');

			//Remove the old items if they still exist.
			$('#'+id+'-error, #'+id+'-result, #'+id+'-spinner').remove();

			if ( url == oldurl[id] )
				return; //URL unchanged.
			
			//Add a spinner.
			var field = $('#' + id);
			field.after('<img src="'+spinnerurl+'" id="'+id+'-spinner" />');

			$.post(ajaxurl, {'action': 'check_siteurl', 'url': url}, function(data) {
				$('#'+id+'-spinner').remove();
				var result = data.split(':', 1)[0];
				var resultdata = data.substring(result.length + 1);

				switch( result ) {

					case 'ok':
						field.after('<img src="'+okurl+'" id="'+id+'-result" />');
						break;
					case 'redirect':
						var text = '<?php echo __('Error: The entered URL redirects to another page, are you certain you did not mean <code>%s</code>?') ?>';
						text = text.replace('%s', resultdata);
						field.after('<span id="'+id+'-result"><img src="'+errorurl+'" /> <strong>'+text+'</strong></span>');
						break;
					case 'error':
						var text = '<?php echo __("Warning: An unknown error(%s) occured during validation, please make sure you\'ve entered the url correctly.") ?>';
						text = text.replace('%s', resultdata);
						field.after('<span id="'+id+'-result"><img src="'+errorurl+'" /> <strong>'+text+'</strong></span>');
						break;
					case 'notwordpressroot':
						var text = '<?php echo __("Warning: WordPress was detected at the given URL, however it is not the WordPress front page, lease make sure you\'ve entered it correctly.") ?>';
						field.after('<span id="'+id+'-result"><img src="'+errorurl+'" /> <strong>'+text+'</strong></span>');						
						break;
					case 'notwordpress':
						var text = '<?php echo __("Warning: WordPress could not be detected at the given URL, Please make sure you\'ve entered it correctly.") ?>';
						field.after('<span id="'+id+'-result"><img src="'+errorurl+'" /> <strong>'+text+'</strong></span>');
						break;
					default:
					case 'unsupported':
						//Nothing.
						break;
				}
			});
		});
		//ajaxurl
	});
//]]>
</script>
<?php
}

add_action('template_redirect', '_siteurl_check_header');
function _siteurl_check_header() {
	if ( isset($_GET['siteurl_check']) ) {
		if ( ! is_front_page() )
			header('wordpress-siteurl-check: false');
		else
			header('wordpress-siteurl-check: true');
		die();
	}
}

add_action('wp_ajax_check_siteurl', '_siteurl_ajax_handler');
function _siteurl_ajax_handler() {
	$url = $_POST['url'];
	$url = add_query_arg('siteurl_check', 'true', $url);
	$transports = array( new WP_Http_Curl(), new WP_Http_Fsockopen() ); //Only these 2 can handle Redirects well.
	$result = false;
	foreach ( $transports as $trans ) {
		if ( $trans->test() ) {
			$result = $trans->request($url, array(
												'method' => 'HEAD',
												'timeout' => apply_filters( 'http_request_timeout', 5),
												'redirection' => 0,
												'httpversion' => apply_filters( 'http_request_version', '1.0'),
												'user-agent' => apply_filters( 'http_headers_useragent', 'WordPress/' . $GLOBALS['wp_version'] . '; ' . get_bloginfo( 'url' )  ),
												'blocking' => true,
												'headers' => array(),
												'cookies' => array(),
												'body' => null,
												'compress' => false,
												'decompress' => true,
												'sslverify' => true
											));
			break;
		}
	}

	if ( false === $result ) {
		die('unsupported');

	} elseif ( is_wp_error($result) ) {
		die('error:' . $result->get_error_message() );

	} elseif ( '200' == $result['response']['code'] && !isset($result['headers']['wordpress-siteurl-check']) ) {
		die('notwordpress');

	} elseif ( isset($result['headers']['wordpress-siteurl-check']) && 'true' != $result['headers']['wordpress-siteurl-check'] ) {
		die('notwordpressroot');

	} elseif ( '301' == $result['response']['code'] || '302' == $result['response']['code'] ) {
		die('redirect:' . remove_query_arg('siteurl_check', $result['headers']['location']) );

	} elseif ( '200' != $result['response']['code'] ) {
		die('error:' . $result['response']['message'] );

	} else {	
		die('ok');

	}
}